require "prefabutil"

local assets=
{
	Asset( "ANIM", "anim/duty_skat.zip" ),
	Asset("ANIM", "anim/dutyskat.zip"),
	Asset("IMAGE", "images/inventoryimages/duty_skat.tex"),
	Asset("ATLAS", "images/inventoryimages/duty_skat.xml"),
}

local prefabs =
{
	"dutyskat",
}

local function nightvision(inst)
	if inst:HasTag("nightonlyvision") and (GetClock():IsNight() or GetWorld():IsCave() or GetClock():IsDusk()) then
		GetClock():SetNightVision(true)
		GetWorld().components.colourcubemanager:SetOverrideColourCube("images/colour_cubes/mole_vision_on_cc.tex", 2)
		else
		GetClock():SetNightVision(false)
		GetWorld().components.colourcubemanager:SetOverrideColourCube(nil, .5)
	end
end

local function removenightvision(inst)
		GetClock():SetNightVision(false)
		GetWorld().components.colourcubemanager:SetOverrideColourCube(nil, .5)
end


local function OnBlocked(owner) 
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour")
end

local function onequip(inst, owner) 
    inst:ListenForEvent("blocked", OnBlocked, owner)
	owner:AddTag("combatskat")
	inst:AddTag("nightonlyvision")
end

local function onunequip(inst, owner) 
    inst:RemoveEventCallback("blocked", OnBlocked, owner)
	owner:RemoveTag("combatskat")
	inst:RemoveTag("nightonlyvision")
	inst:DoTaskInTime(0, removenightvision, nil, owner)
end



local function fnab()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

        	
    inst.AnimState:SetBank("duty_skat")
    inst.AnimState:SetBuild("duty_skat")
    inst.AnimState:PlayAnimation("idle", false)
	
	MakeInventoryPhysics(inst)

        
	-- inst:AddComponent("stackable")
	-- inst.components.stackable.maxsize = 1
	
	
	inst:AddTag("nightonlyvision")
	
	inst:AddComponent("inspectable")
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/marblearmour"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/duty_skat.xml"
    
    inst:AddComponent("armor")
    	
	inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
	inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	inst.components.inventoryitem.keepondeath = true
	
	inst:DoPeriodicTask(3, nightvision, nil, inst)
	
	if IsDLCEnabled(REIGN_OF_GIANTS) then
	inst.components.armor:InitCondition(2000, 0.85)
		
	inst:AddComponent("waterproofer")
	inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_MED)
	
	elseif IsDLCEnabled(0002) then
	inst.components.armor:InitCondition(2000, 0.85)
	
	inst:AddComponent("waterproofer")
	inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_MED)
	
	inst.components.equippable.poisonblocker = true
	inst.components.equippable.poisongasblocker = true
	end

    return inst
end

STRINGS.RECIPE_DESC.DUTY_SKAT = "Repair your suit\ncompletely."

return Prefab( "common/inventory/duty_skat", fnab, assets) 